<?php
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/functions.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/config.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/controller/constants.php';

Class User {


    public function updateOwnSetting( $accessUsername, $accessToken, $name, $currentPassword, $password, $fullName, $nric, $email, $hasNewSingatureImg, $signatureImgPath, $deleteSignature) {
        global $dbConnection;

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $getAccInfo = "SELECT id, extra_info, acc_password FROM library_user WHERE acc_username = '$accessUsername' AND access_token = '$accessToken'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        if ( $getAccCount == 0 ) {

            $outputArray = array( 'status' => 440, 'message' => 'No account is found' );
            outputJson( $outputArray );
            return;
        }

        $extraInfo = array();
        $dbPassword = '';
        $gotNewPassword = false;

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {
            $extraInfo = json_decode( $row[ 'extra_info' ], true );
            $dbPassword = $row[ 'acc_password' ];
        }

        if ( $currentPassword != '' ) {
            $verifyPassword = password_verify( $currentPassword, $dbPassword );

            if ( !$verifyPassword ) {
                $outputArray = array( 'status' => 400, 'message' => 'Current password is wrong' );
                outputJson( $outputArray );
                return;
            }

            $gotNewPassword = true;

        }

        $extraInfo[ 'name' ] = $name;
        $extraInfo[ 'full_name' ] = $fullName;
        $extraInfo[ 'nric' ] = $nric;
        $extraInfo = json_encode( $extraInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES );

        $signatureStr = "";

        if($deleteSignature == 1){
            $signatureStr = ", signature = ''";
        }

        if($signatureImgPath != ""){
            $signatureStr = ", signature = '$signatureImgPath'";
        }


        $updateInfo = "UPDATE library_user SET acc_email = '$email', extra_info = '$extraInfo', date_modified = '$dateTime' $signatureStr WHERE acc_username = '$accessUsername' AND access_token = '$accessToken'";

        $status = mysqli_query( $dbConnection, $updateInfo );

        if($gotNewPassword){

            $newAccessToken = getNewTokenWithTimestamp();

            $password = str_replace( ' ', '', $password );
            $encryptPassword = password_hash( $password, PASSWORD_BCRYPT );

            $updateInfo2 = "UPDATE library_user SET access_token = '$newAccessToken', acc_password = '$encryptPassword' WHERE acc_username = '$accessUsername' AND access_token = '$accessToken'";
            mysqli_query( $dbConnection, $updateInfo2 );
        }
        

        $statusCode = $status ? 200 : 400;
        $message = $status ? 'Updated setting' : 'Failed to setting';

        if($statusCode == 200){
            $this -> syncDataToAuthority($accessUsername);
        }

        $outputArray = array( 'status' => $statusCode, 'message' => $message );
        outputJson( $outputArray );


    }

    private function updateUserInfo($data, $accountDbCode, $updates) {
        foreach ($data as &$type) {
            foreach ($type['contract'] as &$contract) {
                foreach ($contract as $key => &$value) {
                    if (strpos($key, 'approving_authorities_user') === 0) {
                        if ($value['account_db_code'] === $accountDbCode) {
                            foreach ($updates as $updateKey => $updateValue) {
                                $value[$updateKey] = $updateValue;
                            }
                        }
                    }
                }
            }
        }
        return $data;
    }

    private function updateUserInfo2($data, $accountDbCode, $updates) {

        $updates['account_db_code'] = $accountDbCode;

        foreach ($data as $type) {

            $contractList = $type['contract'];
        
            foreach ($contractList as $key2 => $info) {

                if($key2 == "approving_authorities_user1"){

                    $userInfo = $info['approving_authorities_user1'];
                    if ($userInfo['account_db_code'] == $accountDbCode) {
                        foreach ($updates as $updateKey => $updateValue) {
                            $userInfo[$updateKey] = $updateValue;
                        }
                    }

                    $contractList[$key2] = $userInfo;

                }

                
            }
        }


        return $data;
    }

    private function syncDataToAuthority($accessUsername){
        global $dbConnection;
        global $FILE_SERVER_URL;

        $authorityContract = array();

        $getAccInfo = "SELECT contract FROM library_authority WHERE type = 'all_approving_authority'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {
            $authorityContract = json_decode( $row[ 'contract' ], true );
        }

        $getAccInfo = "SELECT * FROM library_user WHERE acc_username = '$accessUsername' AND soft_delete = 'false'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {
            $extraInfo = json_decode( $row[ 'extra_info' ], true );
            $accEmail = $row['acc_email'];
            $accountStatus = $row['account_status'] == "unblocked" ? "available" : "unavailable";
            $accDbCode = $row['acc_db_code'];

            $name = $extraInfo[ 'name' ];
            $nric = $extraInfo[ 'nric' ];
            $position = $extraInfo[ 'position' ];
            $fullName = $extraInfo[ 'full_name' ];

            $signature = $row[ 'signature' ] != "" ? $FILE_SERVER_URL . $row[ 'signature' ] : "";

            $updates = [
                'name' => $name,
                'email' => $accEmail,
                'status' => $accountStatus,
                'nric_no' => $nric,
                'position' => $position,
                'username' => $accessUsername,
                'full_name' => $fullName,
                'signature' => $signature
            ];

            $newAuthorityContract = $this -> updateUserInfo($authorityContract, $accDbCode, $updates);

            $newAuthorityContract = json_encode( $newAuthorityContract, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_HEX_APOS );

            $updateInfo2 = "UPDATE library_authority SET contract = '$newAuthorityContract' WHERE type = 'all_approving_authority'";
            mysqli_query( $dbConnection, $updateInfo2 );

        }
    }

    public function editUser( $accountDbCode, $name, $permissions, $fullName, $nricNo, $position, $email, $status, $loginBlock, $signingAuthority) {
        global $dbConnection;

        $getAccInfo = "SELECT id, acc_username FROM library_user WHERE acc_db_code = '$accountDbCode'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        if ( $getAccCount == 0 ) {

            $outputArray = array( 'status' => 440, 'message' => 'No account is found', 'data' => array() );
            outputJson( $outputArray );
            return;
        }

        $accUsername = "";

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {
            $accUsername = $row['acc_username'];
        }

        $loginBlock = ( int )$loginBlock;
        $loginBlockStr = $loginBlock == 1 ? 'blocked' : 'unblocked';
        $statusStr = $status == 'available' ? 'unblocked' : 'blocked';

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $extraInfo = array( 'name' => $name, 'full_name' => $fullName, 'nric' => $nricNo, 'position' => $position );
        $extraInfo = json_encode( $extraInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES );

        $newAccessToken = getNewTokenWithTimestamp();

        $updateInfo = "UPDATE library_user SET access_token = '$newAccessToken', modules = '$permissions', acc_email = '$email', extra_info = '$extraInfo', account_status = '$statusStr', login_block = '$loginBlockStr', login_failed_count = 0, date_modified = '$dateTime', signing_authority = '$signingAuthority' WHERE acc_db_code = '$accountDbCode'";

        $status = mysqli_query( $dbConnection, $updateInfo );

        $statusCode = $status ? 200 : 400;
        $message = $status ? 'Updated account' : 'Failed to update account';

        if($statusCode == 200 && $accUsername != ''){
            $this -> syncDataToAuthority($accUsername);
        }

        $outputArray = array( 'status' => $statusCode, 'message' => $message );
        outputJson( $outputArray );

    }

    public function updateUserPassword( $newPassword, $userDbCode ) {
        global $dbConnection;

        if ( $newPassword == '' ) {
            $outputArray = array( 'status' => 400, 'message' => 'New password cannot be empty' );
            outputJson( $outputArray );
            return;

        }

        $newPassword = str_replace( ' ', '', $newPassword );
        $encryptPassword = password_hash( $newPassword, PASSWORD_BCRYPT );

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $oneTimeToken = getNewTokenWithTimestamp();

        $updateInfo = "UPDATE library_user SET acc_password = '$encryptPassword', access_token = '$oneTimeToken' WHERE acc_db_code = '$userDbCode'";

        $status = mysqli_query( $dbConnection, $updateInfo );

        $statusCode = $status ? 200 : 400;
        $statusMessage = $status ? 'Update successfully' : 'Failed to update';

        $outputArray = array( 'status' => $statusCode, 'message' => $statusMessage );
        outputJson( $outputArray );
        return;

    }

    public function deleteUser( $userDbCode ) {
        global $dbConnection;

        $getAccInfo = "SELECT id FROM library_user WHERE acc_db_code = '$userDbCode' AND soft_delete = 'false'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        if ( $getAccCount == 0 ) {
            $outputArray = array( 'status' => 440, 'message' => 'Invalid user code' );
            outputJson( $outputArray );
            return;
        }

        $updateInfo = "UPDATE library_user SET login_block = 'blocked', account_status = 'blocked', soft_delete = 'true' WHERE acc_db_code = '$userDbCode'";
        $status = mysqli_query( $dbConnection, $updateInfo );

        $statusCode = $status ? 200 : 400;
        $statusMessage = $status ? 'Deleted successfully' : 'Failed to delete';

        $outputArray = array( 'status' => $statusCode, 'message' => $statusMessage );
        outputJson( $outputArray );
        return;
    }

    public function verifyAccount( $username, $password ) {

        global $dbConnection;
        global $FILE_SERVER_URL;

        $password = str_replace( ' ', '', $password );

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $getAccInfo = "SELECT id, acc_password, account_status, modules, login_block, account_type, extra_info, access_token, acc_email FROM library_user WHERE acc_username = '$username' AND soft_delete = 'false'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        if ( $getAccCount == 0 ) {

            $outputArray = array( 'status' => 440, 'message' => 'No account is found', 'data' => array() );
            outputJson( $outputArray );
            return;
        }

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {

            $loginBlock = $row[ 'login_block' ];
            $status = $row[ 'account_status' ];
            $accountType = $row[ 'account_type' ];
            $extraInfo = $row[ 'extra_info' ];
            $extraInfo =  json_decode( $extraInfo, true );
            $name = $extraInfo[ 'name' ];
            $fullName = $extraInfo[ 'full_name' ];
            $nric = $extraInfo[ 'nric' ];
            $position = $extraInfo[ 'position' ];
            $email = $row[ 'acc_email' ];
            $signature = $row[ 'signature' ] != "" ? $FILE_SERVER_URL . $row[ 'signature' ] : "";


            
            
            $modules = $row[ 'modules' ];
            $modules =  json_decode( $modules, true );

            if ( $status == 'blocked' || $loginBlock == 'blocked' ) {
                $outputArray = array( 'status' => 444, 'message' => 'Your account is blocked, kindly contact admin', 'data' => array() );
                outputJson( $outputArray );
                return;
            }

            $verifyPassword = password_verify( $password, $row[ 'acc_password' ] );

            if ( !$verifyPassword ) {

                $updateInfo = "UPDATE library_user SET login_failed_count = login_failed_count + 1, login_block = CASE WHEN login_failed_count >= 5 THEN 'blocked' ELSE login_block END WHERE acc_username = '$username'";
                $status = mysqli_query( $dbConnection, $updateInfo );

                $outputArray = array( 'status' => 400, 'message' => 'Failed to login, please check username and password', 'data' => array() );
                outputJson( $outputArray );
                return;

            } else if ( $verifyPassword ) {

                $oneTimeToken = getNewTokenWithTimestamp();
                // initAdminCookie( $username, $oneTimeToken );

                $updateInfo = "UPDATE library_user SET access_token = '$oneTimeToken', last_login = '$dateTime', login_failed_count = 0 WHERE acc_username = '$username'";

                $status = mysqli_query( $dbConnection, $updateInfo );

                $statusCode = $status ? 200 : 400;
                $statusMessage = $status ? 'Login successfully' : 'Failed to login';

                $dataOutput = array( 'access_token' => $oneTimeToken, 'username' => $username, 'name' => $name, 'full_name' => $fullName, 'nric' => $nric, 'position' => $position, 'phone' => "", 'lang' => 'en', 'account_type' => strtolower($accountType), 'unread_notifications' => 0, 'modules' => $modules, 'email' => $email, 'signature' => $signature );

                $outputArray = array( 'status' => $statusCode, 'message' => $statusMessage, 'data' => $dataOutput );
                outputJson( $outputArray );
                return;

            }
        }

    }

    public function getOwnSetting($accessUsername, $accessToken) {
        global $dbConnection;
        global $FILE_SERVER_URL;

        $userList = array();

        $getAccountInfo = "SELECT * FROM library_user WHERE soft_delete = 'false' AND acc_username = '$accessUsername' AND access_token = '$accessToken'";

        $getAccountInfoQuery = mysqli_query( $dbConnection, $getAccountInfo );

        if ( $row = mysqli_fetch_assoc( $getAccountInfoQuery ) ) {
            $row[ 'extra_info' ] = json_decode( $row[ 'extra_info' ], true );
            $row[ 'modules' ] = json_decode( $row[ 'modules' ], true );

            $row[ 'date_modified' ] =  $row[ 'date_modified' ] == null ? '' :  $row[ 'date_modified' ];
            $row[ 'last_login' ] =  $row[ 'last_login' ] == null ? '' :  $row[ 'last_login' ];
            $row[ 'access_token' ] =  $row[ 'access_token' ] == null ? '' :  $row[ 'access_token' ];

            $row[ 'account_type' ] = strtolower($row[ 'account_type' ]);
            $row[ 'unread_notifications' ] = 0;
            $row[ 'lang' ] = 'en';
            $row[ 'phone' ] = '';

            $row[ 'account_db_code' ] = $row[ 'acc_db_code' ];
            $row[ 'full_name' ] = $row[ 'extra_info' ][ 'full_name' ];
            $row[ 'nric_no' ] = $row[ 'extra_info' ][ 'nric' ];
            $row[ 'name' ] = $row[ 'extra_info' ][ 'name' ];
            $row[ 'position' ] = $row[ 'extra_info' ][ 'position' ];
            $row[ 'email' ] = $row[ 'acc_email' ];
            $row[ 'username' ] = $row[ 'acc_username' ];
            $row[ 'status' ] = $row[ 'account_status' ] == 'blocked' ? 'unavailable' : 'available';
            $row[ 'login_block' ] = $row[ 'login_block' ] == "unblocked" ? 0 : 1;
            $row[ 'signature' ] = $row[ 'signature' ] != "" ? $FILE_SERVER_URL . $row[ 'signature' ] : "";


            unset( $row[ 'account_status' ] );
            unset( $row[ 'extra_info' ] );
            unset( $row[ 'acc_db_code' ] );
            unset( $row[ 'acc_password' ] );
            unset( $row[ 'id' ] );
            unset( $row[ 'acc_email' ] );
            unset( $row[ 'acc_username' ] );

            $userList = $row;
        }

        $outputArray = array( 'status' => 200, 'message' => 'Loaded data', 'data' => $userList );
        outputJson( $outputArray );

    }

    public function getAllUserList( $page, $limit ) {
        global $dbConnection;
        global $FILE_SERVER_URL;

        $getAccountTotal = "SELECT * FROM library_user WHERE soft_delete = 'false' ORDER BY id";
        $getAccountTotalQuery = mysqli_query( $dbConnection, $getAccountTotal );
        $getAccCount = mysqli_num_rows( $getAccountTotalQuery );

        $userList = array();

        $getAccountInfo = "SELECT * FROM library_user WHERE soft_delete = 'false' ORDER BY id DESC LIMIT 
        $page, $limit";

        $getAccountInfoQuery = mysqli_query( $dbConnection, $getAccountInfo );

        while ( $row = mysqli_fetch_assoc( $getAccountInfoQuery ) ) {
            $row[ 'extra_info' ] = json_decode( $row[ 'extra_info' ], true );
            $row[ 'modules' ] = json_decode( $row[ 'modules' ], true );

            $row[ 'date_modified' ] =  $row[ 'date_modified' ] == null ? '' :  $row[ 'date_modified' ];
            $row[ 'last_login' ] =  $row[ 'last_login' ] == null ? '' :  $row[ 'last_login' ];

            $row[ 'account_db_code' ] = $row[ 'acc_db_code' ];
            $row[ 'full_name' ] = $row[ 'extra_info' ][ 'full_name' ];
            $row[ 'nric_no' ] = $row[ 'extra_info' ][ 'nric' ];
            $row[ 'name' ] = $row[ 'extra_info' ][ 'name' ];
            $row[ 'position' ] = $row[ 'extra_info' ][ 'position' ];
            $row[ 'email' ] = $row[ 'acc_email' ];
            $row[ 'username' ] = $row[ 'acc_username' ];
            $row[ 'status' ] = $row[ 'account_status' ] == 'blocked' ? 'unavailable' : 'available';
            $row[ 'account_type' ] = strtolower($row[ 'account_type' ]);

            $row[ 'signature' ] = $row[ 'signature' ] != "" ? $FILE_SERVER_URL . $row[ 'signature' ] : "";
            $row[ 'login_block' ] = $row[ 'login_block' ] == "unblocked" ? 0 : 1;
            unset( $row[ 'account_status' ] );
            unset( $row[ 'extra_info' ] );
            unset( $row[ 'acc_db_code' ] );
            unset( $row[ 'acc_password' ] );
            unset( $row[ 'id' ] );
            unset( $row[ 'acc_email' ] );
            unset( $row[ 'access_token' ] );
            unset( $row[ 'acc_username' ] );

            $userList[] = $row;
        }

        $outputArray = array( 'status' => 200, 'message' => 'Loaded data', 'data' => $userList, 'total' => $getAccCount );
        outputJson( $outputArray );

    }

    public function createNewUser($name, $username, $password, $modules, $accountType, $fullName, $nricNo, $signature, $position, $email, $signingAuthority) {

        global $dbConnection;
        $username = str_replace( ' ', '', $username );
        $password = str_replace( ' ', '', $password );

        $encryptPassword = password_hash( $password, PASSWORD_BCRYPT );
        $checkAcc = $this -> confirmNoUsernameHasNotBeenUsed( $username );

        if ( !$checkAcc ) {
            $outputArray = array( 'status' => 400, 'message' => 'Please use another username' );
            outputJson( $outputArray );
            return;
        }

        // INSERT NEW ACCOUNT WITH MODULES
        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $extraInfo = array( 'name' => $name, 'full_name' => $fullName, 'nric' => $nricNo, 'position' => $position );
        $extraInfo = json_encode( $extraInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES );

        $accDbCode = getNewTokenWithTimestamp();
        $insertRecord = 'INSERT INTO library_user (acc_db_code, acc_email, acc_username, acc_password, extra_info, modules, account_type, signature, date_created, signing_authority)';

        $insertRecord .= " VALUES ('$accDbCode', '$email', '$username', '$encryptPassword', '$extraInfo', '$modules', 'ADMIN', '$signature', '$dateTime', '$signingAuthority')";
        $status = mysqli_query( $dbConnection, $insertRecord );

        $statusCode = $status ? 200 : 400;
        $message = $status ? 'Created new account' : 'Failed to create new account';

        $outputArray = array( 'status' => $statusCode, 'message' => $message );
        outputJson( $outputArray );
    }

    private function confirmNoUsernameHasNotBeenUsed( $username ) {

        global $dbConnection;

        $getAccInfo = "SELECT id FROM library_user WHERE acc_username = '$username'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        $allowToProceed = true;

        if ( $getAccCount > 0 ) {
            $allowToProceed = false;
        }

        return $allowToProceed;
    }

    public function verifyUserToken( $username, $token ) {
        global $dbConnection;

        $getAccountInfo = "SELECT id, account_status FROM library_user WHERE acc_username = '$username' AND access_token = '$token' AND soft_delete = 'false'";
        $getAccountInfoQuery = mysqli_query( $dbConnection, $getAccountInfo );

        $getUserCount = mysqli_num_rows( $getAccountInfoQuery );

        if($getUserCount == 0){
            return array('status' => 400, 'role' => 'admin');
        }

        if ( $row = mysqli_fetch_assoc( $getAccountInfoQuery ) ) {
            $userStatus = $row[ 'account_status' ];

            if ( $userStatus == 'blocked' ) {
                return array('status' => 444, 'role' => 'admin');
            }
        }
        return array('status' => 200, 'role' => 'admin');
    }
}